using Statistics
using DataFrames
using CSV

# Define functions

uncompressed() = CSV.read("crsp_daily.csv", DataFrame)

function processing()
	#R = by(data, [:year, :PERMNO]) do data
	#	DataFrame(m = mean(data.RET), s = std(data.RET), c = length(data.RET))
	#end
	R = combine(groupby(data, [:year, :PERMNO]),
   	:RET => mean => :m, :RET => std => :s, nrow => :c)
end



# Loading - Uncompressed

load_uncomp = @elapsed data = uncompressed();
println("output,Julia,read_uncompressed,", load_uncomp)

# Processing

data = data[completecases(data),:];
data.year = Int32.(round.(data.date/10000));
data.RET = map(x -> (v = tryparse(Float64,x); isnothing(v) ? missing : v), data.RET);
data = data[completecases(data),:];

processing_time = @elapsed processing();
println("output,Julia,process,", processing_time)
